import iesve
from results import max_loads
from ies_file_picker import IesFilePicker

project = iesve.VEProject.get_current_project()
model = project.models[0]
bodies = model.get_bodies(False)
s = iesve.ApacheSim()
geom = iesve.VEGeometry

s.run_simulation()

file_name = IesFilePicker.pick_aps_file()

f = iesve.ResultsReader()
f.open_aps_data(file_name)

max_BL = max_loads(f)
print(max_BL)

percent = 90
while (percent>10) & (max_BL>4500):
    percent -= 10
    geom = iesve.VEGeometry
    for body in bodies:
        body.select()
    geom.set_percent_wall_glazing(percent)
    s.run_simulation()
    f = iesve.ResultsReader()
    f.open_aps_data(file_name)
    max_BL = max_loads(f)
    print(max_BL)   

 